XIncludeFile "export.pbi"

Procedure ExportRequester(file.s)
  If file
    If FindString(file, ".inc", 1) = 0
      file = file + ".inc"
    EndIf
    If FileSize(file) > 0
      If MessageRequester("Error", "File already exists. Replace it ?", #PB_MessageRequester_YesNo) = #PB_MessageRequester_Yes
        DeleteFile(file)
      Else
        ProcedureReturn
      EndIf
    EndIf
    ExportMap(file)
  EndIf
EndProcedure

Procedure ExportMap(file.s)
  Protected x.l, y.l, i.l = 0

  If CreateFile(0, "objects.asm") = 0
    MessageRequester("OpenFile() error", "Can't export objects.asm")
    ProcedureReturn
  EndIf
  WriteStringN(0, "Brushes:")
  ForEach brushes()
    WriteStringN(0, Chr(9)+".dw "+brushes()\name)
    i+1
  Next
  WriteStringN(0, "")
  i = 0
  ForEach brushes()
    WriteStringN(0, brushes()\name+":")
    WriteString(0, Chr(9)+".db %")
    If brushes()\interaction <> ""
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\collision <> ""
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    WriteString(0, "000") ; Currently unused (?)
    If brushes()\height > 0 Or brushes()\mask > 0
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\notpassable
      WriteString(0, "1")
    Else
      WriteString(0, "0")
    EndIf
    If brushes()\animated
      WriteStringN(0, "1")
    Else
      WriteStringN(0, "0")
    EndIf
    WriteString(0, Chr(9)+".db "+Str(brushes()\tile))
    If brushes()\animated
      WriteStringN(0, Str(brushes()\offset))
    Else
      WriteStringN(0, "")
    EndIf
    If brushes()\height > 0 Or brushes()\mask > 0
      WriteStringN(0, Chr(9)+".db "+Str(brushes()\mask))
      WriteStringN(0, Chr(9)+".db "+Str(brushes()\height))
    EndIf
    If brushes()\interaction <> ""
      ReplaceString(brushes()\interaction, " | " , Chr(13)+Chr(10), #PB_String_CaseSensitive)
    EndIf
    If brushes()\collision <> ""
      ReplaceString(brushes()\collision, " | " , Chr(13)+Chr(10), #PB_String_CaseSensitive)
    EndIf
    i+1
  Next
  CloseFile(0)

  If CreateFile(0, "tiles.inc") = 0
    MessageRequester("OpenFile() error", "Can't export tiles.inc")
    ProcedureReturn
  EndIf
  WriteStringN(0, "tileData:")
  ForEach tiles()
    WriteStringN(0, "#include"+Chr(9)+Chr(34)+"masks"+#Path_separator+tiles()+Chr(34))
  Next
  WriteStringN(0, "")
  
  If CreateFile(0, "masks.inc") = 0
    MessageRequester("OpenFile() error", "Can't export masks.inc")
    ProcedureReturn
  EndIf
  WriteStringN(0, "maskTiles:")
  ForEach masks()
    WriteStringN(0, "#include"+Chr(9)+Chr(34)+"masks"+#Path_separator+masks()+Chr(34))
  Next
  WriteStringN(0, "")

  If CreateFile(0, file) = 0
    MessageRequester("OpenFile() error", "Can't export map.")
    ProcedureReturn
  EndIf

  WriteStringN(0, map_\title+":")
  WriteStringN(0, Chr(9)+".db "+Str(map_\w)+","+Str(map_\h)+",$"+RSet(Hex(map_\default_tile), 2, "0"))
  For y=0 To map_\h-1
    WriteString(0, Chr(9)+".db ")
    For x=0 To map_\w-1
      WriteString(0, "$"+RSet(Hex(map_data(x, y)\id), 2, "0"))
      If x<>map_\w-1
        WriteString(0, ",")
      EndIf
    Next x
    WriteStringN(0, "")
  Next y

  CloseFile(0)
  CompilerIf #PB_Compiler_OS = #PB_OS_Windows
    sndPlaySound_("ding.wav", 0)
  CompilerEndIf
EndProcedure
; IDE Options = PureBasic 5.00 (Windows - x86)
; CursorPosition = 87
; FirstLine = 78
; Folding = -
; EnableXP
; UseMainFile = main.pb
; CurrentDirectory = ..\